IF OBJECT_ID('P_REPROCESSAR_EST_NF_ENT_IT_PRODUTO_CADASTRO') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_REPROCESSAR_EST_NF_ENT_IT_PRODUTO_CADASTRO
	END 
GO
--exec P_REPROCESSAR_EST_NF_ENT_IT_PRODUTO_CADASTRO 4,2012
CREATE PROCEDURE [dbo].[P_REPROCESSAR_EST_NF_ENT_IT_PRODUTO_CADASTRO]( @MES INT=NULL, @ANO INT=NULL,@CD_FILIAL_PAR INT=0)  AS

DISABLE TRIGGER TRG_EST_PROD_CPL_ULT_MOV_GLB_MOV_OP_ENTRADA ON EST_NF_ENT_IT;
	
	DECLARE @DT_INI DATETIME
	DECLARE @DT_FIM DATETIME
	DECLARE @DIA DATETIME
	DECLARE @CD_FILIAL AS INT
	DECLARE @AGORA DATETIME

	
	SET NOCOUNT ON
	IF @ANO IS NULL OR @MES IS NULL
		begin
			SELECT @AGORA=DATEADD(month, -1, GETDATE()), @ANO=YEAR(@AGORA), @MES=MONTH(@AGORA)
		end
	
	SET @DT_INI = CONVERT(DATETIME, (CONVERT(VARCHAR, (@ANO*100+@MES)) + '01')) ;
	SET @DT_FIM = dbo.F_FINAL_MES (@DT_INI) ;
	
	--RODA SO ATE ONTEM
	IF  @DT_FIM > dbo.F_HOJE()
	BEGIN
		SET @DT_FIM = dbo.F_HOJE() -1 
	END
	
	DECLARE cFilial CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT  
	 	CD_FILIAL
	FROM 
		PRC_FILIAL
	WHERE 
		CD_EMP = 1  
		AND CD_FILIAL = CASE WHEN @CD_FILIAL_PAR = 0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
	OPEN CFILIAL
	FETCH NEXT FROM cFilial INTO @CD_FILIAL

	WHILE @@FETCH_STATUS=0
	BEGIN
		SET @DIA = @DT_INI
		WHILE @DT_FIM >= @DIA
			BEGIN

				PRINT 'Filial ' + CONVERT(VARCHAR, @CD_FILIAL) + ' -  Processando dia  ' + CONVERT(VARCHAR, @DIA, 112) + ' ' + CONVERT(VARCHAR, GETDATE (),108)

				UPDATE 
					i 
				SET
					i.LISTA_PROD =  p.LISTA_PROD ,
					i.PIS_COFINS = p.PIS_COFINS,
					i.TIPO_TRIBUTACAO_PIS_COFINS = ISNULL(p.TIPO_TRIBUTACAO_PIS_COFINS_ENTRADA,0),
					i.SIGLA_EXCECAO_PIS_COFINS=ISNULL(p.SIGLA_EXCECAO_PIS_COFINS,''),
					i.FLAG_EXCECAO_PIS_COFINS=ISNULL(p.FLAG_EXCECAO_PIS_COFINS,0)
				FROM
					EST_NF_ENT INNER JOIN EST_NF_ENT_IT i ON
					EST_NF_ENT.CD_EMP  = i.CD_EMP AND
					EST_NF_ENT.CD_FILIAL = i.CD_FILIAL AND
					EST_NF_ENT.CD_NF = i.CD_NF
					INNER JOIN EST_PROD p ON 
					i.CD_EMP = p.CD_EMP AND 
					i.CD_PROD = p.CD_PROD
				WHERE
					EST_NF_ENT.CD_EMP = 1 
					AND EST_NF_ENT.CD_FILIAL = @CD_FILIAL 
					AND EST_NF_ENT.DT_ENT = @DIA
				
				SELECT @DIA = @DIA + 1
			END		
		FETCH NEXT FROM  cFilial INTO @CD_FILIAL 
	END
CLOSE cFilial;
DEALLOCATE cFilial;

ENABLE TRIGGER TRG_EST_PROD_CPL_ULT_MOV_GLB_MOV_OP_ENTRADA ON EST_NF_ENT_IT;
GO


